/****************************************************************************
* Donohue and Wolfers (2006) 
* Table 4
* Estimating the Effects of Executions on Murder Rates Using the Katz,
* Levitt, and Shustorovich Model for Three Time Periods: 1934-2000
****************************************************************************/


clear
set matsize 800
set mem 250m
set more off
cd  "..."

*Panel A
use "StatePanel", clear
summ cri_prop cri_viol pc_mur r_execut r_death c_pris_1 pcpris_1 rpc_inc r_ue r_infd r_black r_urban r_0_24 r_25_44 [w=popul] if sample_kls==1
xi: reg pc_mur r_execut r_death i.stname i.year [w=popul] if sample_kls==1, cluster(st)
lincom -_b[r_execut]*((229300000/100000)/38)/(943.6/38)-1
lincom -(_b[r_execut]+1.96*_se[r_execut])*((229300000/100000)/38)/(943.6/38)-1
lincom -(_b[r_execut]-1.96*_se[r_execut])*((229300000/100000)/38)/(943.6/38)-1
xi: reg pc_mur r_execut r_death c_pris_1 pcpris_1 rpc_inc r_ue r_black r_urban r_0_24 r_25_44 r_infd i.stname i.year [w=popul] if sample_kls==1, cluster(st)
lincom -_b[r_execut]*((229300000/100000)/38)/(943.6/38)-1
lincom -(_b[r_execut]+1.96*_se[r_execut])*((229300000/100000)/38)/(943.6/38)-1
lincom -(_b[r_execut]-1.96*_se[r_execut])*((229300000/100000)/38)/(943.6/38)-1
xi: reg pc_mur r_execut r_death i.stname i.region*i.year [w=popul] if sample_kls==1, cluster(st)
lincom -_b[r_execut]*((229300000/100000)/38)/(943.6/38)-1
lincom -(_b[r_execut]+1.96*_se[r_execut])*((229300000/100000)/38)/(943.6/38)-1
lincom -(_b[r_execut]-1.96*_se[r_execut])*((229300000/100000)/38)/(943.6/38)-1
xi: reg pc_mur r_execut r_death c_pris_1 pcpris_1 rpc_inc r_ue r_black r_urban r_0_24 r_25_44 r_infd i.stname i.region*i.year [w=popul] if sample_kls==1, cluster(st)
lincom -_b[r_execut]*((229300000/100000)/38)/(943.6/38)-1
lincom -(_b[r_execut]+1.96*_se[r_execut])*((229300000/100000)/38)/(943.6/38)-1
lincom -(_b[r_execut]-1.96*_se[r_execut])*((229300000/100000)/38)/(943.6/38)-1
xi: reg pc_mur r_execut r_death i.stname*year i.year [w=popul] if sample_kls==1, cluster(st)
lincom -_b[r_execut]*((229300000/100000)/38)/(943.6/38)-1
lincom -(_b[r_execut]+1.96*_se[r_execut])*((229300000/100000)/38)/(943.6/38)-1
lincom -(_b[r_execut]-1.96*_se[r_execut])*((229300000/100000)/38)/(943.6/38)-1
xi: reg pc_mur r_execut r_death c_pris_1 pcpris_1 rpc_inc r_ue r_black r_urban r_0_24 r_25_44 r_infd i.stname*year i.year [w=popul] if sample_kls==1, cluster(st)
lincom -_b[r_execut]*((229300000/100000)/38)/(943.6/38)-1
lincom -(_b[r_execut]+1.96*_se[r_execut])*((229300000/100000)/38)/(943.6/38)-1
lincom -(_b[r_execut]-1.96*_se[r_execut])*((229300000/100000)/38)/(943.6/38)-1
xi: reg pc_mur r_execut r_death i.stname*i.decade i.year [w=popul] if sample_kls==1, cluster(st)
lincom -_b[r_execut]*((229300000/100000)/38)/(943.6/38)-1
lincom -(_b[r_execut]+1.96*_se[r_execut])*((229300000/100000)/38)/(943.6/38)-1
lincom -(_b[r_execut]-1.96*_se[r_execut])*((229300000/100000)/38)/(943.6/38)-1
xi: reg pc_mur r_execut r_death c_pris_1 pcpris_1 rpc_inc r_ue r_black r_urban r_0_24 r_25_44 r_infd i.stname*i.decade i.year [w=popul] if sample_kls==1, cluster(st)
lincom -_b[r_execut]*((229300000/100000)/38)/(943.6/38)-1
lincom -(_b[r_execut]+1.96*_se[r_execut])*((229300000/100000)/38)/(943.6/38)-1
lincom -(_b[r_execut]-1.96*_se[r_execut])*((229300000/100000)/38)/(943.6/38)-1

*Panel B
gen sample_kls_2000=1
replace sample_kls_2000=. if (/*cri_prop+cri_viol+*/pc_mur+r_death+r_execut+c_pris_1+pcpris_1+rpc_inc+r_ue+r_infd+r_black+r_urban+r_0_24+r_25_44)==.
replace sample_kls_2000=. if year<1950 | year>2000
replace sample_kls_2000=. if year==1971
replace sample_kls_2000=. if popul==.

summ cri_prop cri_viol pc_mur r_execut r_death c_pris_1 pcpris_1 rpc_inc r_ue r_infd r_black r_urban r_0_24 r_25_44 [w=popul] if sample_kls_2000==1

xi: reg pc_mur r_execut r_death i.stname i.year [w=popul] if sample_kls_2000==1, cluster(st)
lincom -_b[r_execut]*((229300000/100000)/38)/(943.6/38)-1
lincom -(_b[r_execut]+1.96*_se[r_execut])*((229300000/100000)/38)/(943.6/38)-1
lincom -(_b[r_execut]-1.96*_se[r_execut])*((229300000/100000)/38)/(943.6/38)-1
xi: reg pc_mur r_execut r_death c_pris_1 pcpris_1 rpc_inc r_ue r_black r_urban r_0_24 r_25_44 r_infd i.stname i.year [w=popul] if sample_kls_2000==1, cluster(st)
lincom -_b[r_execut]*((229300000/100000)/38)/(943.6/38)-1
lincom -(_b[r_execut]+1.96*_se[r_execut])*((229300000/100000)/38)/(943.6/38)-1
lincom -(_b[r_execut]-1.96*_se[r_execut])*((229300000/100000)/38)/(943.6/38)-1
xi: reg pc_mur r_execut r_death i.stname i.region*i.year [w=popul] if sample_kls_2000==1, cluster(st)
lincom -_b[r_execut]*((229300000/100000)/38)/(943.6/38)-1
lincom -(_b[r_execut]+1.96*_se[r_execut])*((229300000/100000)/38)/(943.6/38)-1
lincom -(_b[r_execut]-1.96*_se[r_execut])*((229300000/100000)/38)/(943.6/38)-1
xi: reg pc_mur r_execut r_death c_pris_1 pcpris_1 rpc_inc r_ue r_black r_urban r_0_24 r_25_44 r_infd  i.stname i.region*i.year [w=popul] if sample_kls_2000==1, cluster(st)
lincom -_b[r_execut]*((229300000/100000)/38)/(943.6/38)-1
lincom -(_b[r_execut]+1.96*_se[r_execut])*((229300000/100000)/38)/(943.6/38)-1
lincom -(_b[r_execut]-1.96*_se[r_execut])*((229300000/100000)/38)/(943.6/38)-1
xi: reg pc_mur r_execut r_death i.stname*year i.year [w=popul] if sample_kls_2000==1, cluster(st)
lincom -_b[r_execut]*((229300000/100000)/38)/(943.6/38)-1
lincom -(_b[r_execut]+1.96*_se[r_execut])*((229300000/100000)/38)/(943.6/38)-1
lincom -(_b[r_execut]-1.96*_se[r_execut])*((229300000/100000)/38)/(943.6/38)-1
xi: reg pc_mur r_execut r_death c_pris_1 pcpris_1 rpc_inc r_ue r_black r_urban r_0_24 r_25_44 r_infd i.stname*year i.year [w=popul] if sample_kls_2000==1, cluster(st)
lincom -_b[r_execut]*((229300000/100000)/38)/(943.6/38)-1
lincom -(_b[r_execut]+1.96*_se[r_execut])*((229300000/100000)/38)/(943.6/38)-1
lincom -(_b[r_execut]-1.96*_se[r_execut])*((229300000/100000)/38)/(943.6/38)-1
xi: reg pc_mur r_execut r_death i.stname*i.decade i.year [w=popul] if sample_kls_2000==1, cluster(st)
lincom -_b[r_execut]*((229300000/100000)/38)/(943.6/38)-1
lincom -(_b[r_execut]+1.96*_se[r_execut])*((229300000/100000)/38)/(943.6/38)-1
lincom -(_b[r_execut]-1.96*_se[r_execut])*((229300000/100000)/38)/(943.6/38)-1
xi: reg pc_mur r_execut r_death c_pris_1 pcpris_1 rpc_inc r_ue r_black r_urban r_0_24 r_25_44 r_infd i.stname*i.decade i.year [w=popul] if sample_kls_2000==1, cluster(st)
lincom -_b[r_execut]*((229300000/100000)/38)/(943.6/38)-1
lincom -(_b[r_execut]+1.96*_se[r_execut])*((229300000/100000)/38)/(943.6/38)-1
lincom -(_b[r_execut]-1.96*_se[r_execut])*((229300000/100000)/38)/(943.6/38)-1

*Panel C
gen sample_kls_long=1
replace sample_kls_long=. if (/*cri_prop+cri_viol+*/ pc_mur+r_death+r_execut+c_pris_1+pcpris_1+rpc_inc+r_black+r_urban+r_0_24+r_25_44)==.
replace sample_kls_long=. if year>2000
replace sample_kls_long=. if year==1971
replace sample_kls_long=. if popul==.
xi: reg pc_mur r_execut r_death i.stname i.year [w=popul] if sample_kls_long==1, cluster(st)
lincom -_b[r_execut]*((229300000/100000)/38)/(943.6/38)-1
lincom -(_b[r_execut]+1.96*_se[r_execut])*((229300000/100000)/38)/(943.6/38)-1
lincom -(_b[r_execut]-1.96*_se[r_execut])*((229300000/100000)/38)/(943.6/38)-1
xi: reg pc_mur r_execut r_death c_pris_1 pcpris_1 rpc_inc r_black r_urban r_0_24 r_25_44 i.stname i.year [w=popul] if sample_kls_long==1, cluster(st)
lincom -_b[r_execut]*((229300000/100000)/38)/(943.6/38)-1
lincom -(_b[r_execut]+1.96*_se[r_execut])*((229300000/100000)/38)/(943.6/38)-1
lincom -(_b[r_execut]-1.96*_se[r_execut])*((229300000/100000)/38)/(943.6/38)-1
xi: reg pc_mur r_execut r_death i.stname i.region*i.year [w=popul] if sample_kls_long==1, cluster(st)
lincom -_b[r_execut]*((229300000/100000)/38)/(943.6/38)-1
lincom -(_b[r_execut]+1.96*_se[r_execut])*((229300000/100000)/38)/(943.6/38)-1
lincom -(_b[r_execut]-1.96*_se[r_execut])*((229300000/100000)/38)/(943.6/38)-1
xi: reg pc_mur r_execut r_death c_pris_1 pcpris_1 rpc_inc r_black r_urban r_0_24 r_25_44 i.stname i.region*i.year [w=popul] if sample_kls_long==1, cluster(st)
lincom -_b[r_execut]*((229300000/100000)/38)/(943.6/38)-1
lincom -(_b[r_execut]+1.96*_se[r_execut])*((229300000/100000)/38)/(943.6/38)-1
lincom -(_b[r_execut]-1.96*_se[r_execut])*((229300000/100000)/38)/(943.6/38)-1
xi: reg pc_mur r_execut r_death i.stname*year i.year [w=popul] if sample_kls_long==1, cluster(st)
lincom -_b[r_execut]*((229300000/100000)/38)/(943.6/38)-1
lincom -(_b[r_execut]+1.96*_se[r_execut])*((229300000/100000)/38)/(943.6/38)-1
lincom -(_b[r_execut]-1.96*_se[r_execut])*((229300000/100000)/38)/(943.6/38)-1
xi: reg pc_mur r_execut r_death c_pris_1 pcpris_1 rpc_inc r_black r_urban r_0_24 r_25_44 i.stname*year i.year [w=popul] if sample_kls_long==1, cluster(st)
lincom -_b[r_execut]*((229300000/100000)/38)/(943.6/38)-1
lincom -(_b[r_execut]+1.96*_se[r_execut])*((229300000/100000)/38)/(943.6/38)-1
lincom -(_b[r_execut]-1.96*_se[r_execut])*((229300000/100000)/38)/(943.6/38)-1
xi: reg pc_mur r_execut r_death i.stname*i.decade i.year [w=popul] if sample_kls_long==1, cluster(st)
lincom -_b[r_execut]*((229300000/100000)/38)/(943.6/38)-1
lincom -(_b[r_execut]+1.96*_se[r_execut])*((229300000/100000)/38)/(943.6/38)-1
lincom -(_b[r_execut]-1.96*_se[r_execut])*((229300000/100000)/38)/(943.6/38)-1
xi: reg pc_mur r_execut r_death c_pris_1 pcpris_1 rpc_inc r_black r_urban r_0_24 r_25_44 i.stname*i.decade i.year [w=popul] if sample_kls_long==1, cluster(st)
lincom -_b[r_execut]*((229300000/100000)/38)/(943.6/38)-1
lincom -(_b[r_execut]+1.96*_se[r_execut])*((229300000/100000)/38)/(943.6/38)-1
lincom -(_b[r_execut]-1.96*_se[r_execut])*((229300000/100000)/38)/(943.6/38)-1

